/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.baked.EmptyVertexConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemMeshEmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_12247;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_9801;

@Environment(value=EnvType.CLIENT)
public class BakedItemModelBufferer {
    static final Map<BlendFunction, Transparency> TRANSPARENCY = Map.of(BlendFunction.ADDITIVE, Transparency.ADDITIVE, BlendFunction.LIGHTNING, Transparency.LIGHTNING, BlendFunction.GLINT, Transparency.GLINT, BlendFunction.TRANSLUCENT, Transparency.TRANSLUCENT);
    static final List<class_1921> CHUNK_LAYERS = List.of(class_4722.method_24073(), class_4722.method_24074(), class_4722.method_29382(), class_12249.method_75995(), class_12249.method_75993(), class_12249.method_75997());
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static void bufferItemStack(class_1799 stack, class_1920 level, class_811 displayContext, ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
        class_638 clientWorld;
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.identityPoseStack;
        class_638 world = level instanceof class_638 ? (clientWorld = (class_638)level) : null;
        ItemMeshEmitterProvider provider = objects.provider;
        provider.setResultConsumer(resultConsumer, meshResultConsumer);
        class_10444 state = objects.state;
        class_11684 dispatcher = objects.featureRenderDispatcher;
        class_310.method_1551().method_65386().method_65598(state, stack, displayContext, (class_1937)world, null, 0);
        state.method_65604(poseStack, (class_11659)dispatcher.method_73003(), 0, class_4608.field_21444, 0);
        dispatcher.method_73002();
        provider.method_22993();
    }

    public static Map<class_1921, Integer> getChunkLayers() {
        return BakedItemModelBufferer.THREAD_LOCAL_OBJECTS.get().chunkLayers;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_10444 state = new class_10444();
        public final ItemMeshEmitterProvider provider = new ItemMeshEmitterProvider(this);
        public final Map<class_1921, Material> materials = new HashMap<class_1921, Material>();
        public final Map<class_1921, Integer> chunkLayers = new HashMap<class_1921, Integer>();
        public final List<ItemMeshEmitter> emitters = new ArrayList<ItemMeshEmitter>();
        public final class_11684 featureRenderDispatcher;

        private ThreadLocalObjects() {
            class_310 mc = class_310.method_1551();
            this.featureRenderDispatcher = new class_11684(new class_11661(), mc.method_1541(), (class_4597.class_4598)this.provider, mc.method_72703(), (class_4618)EmptyOutlineBufferSource.INSTANCE, (class_4597.class_4598)EmptyBufferSource.INSTANCE, mc.field_1772);
            int size = CHUNK_LAYERS.size();
            for (int i = 0; i < size; ++i) {
                class_1921 renderType = CHUNK_LAYERS.get(i);
                this.chunkLayers.put(renderType, i);
                this.emitters.add(new ItemMeshEmitter(renderType));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemMeshEmitterProvider
    extends class_4597.class_4598 {
        private final ThreadLocalObjects objects;
        private ResultConsumer resultConsumer;
        private MeshResultConsumer meshResultConsumer;

        private ItemMeshEmitterProvider(ThreadLocalObjects objects) {
            super(null, null);
            this.objects = objects;
        }

        public void setResultConsumer(ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
            this.resultConsumer = resultConsumer;
            this.meshResultConsumer = meshResultConsumer;
        }

        private void emitMesh(class_1921 renderType, Mesh mesh, boolean translucent) {
            Material material = this.objects.materials.computeIfAbsent(renderType, ItemMeshEmitterProvider::createMaterial);
            this.meshResultConsumer.accept(renderType, material, mesh, translucent);
        }

        private static Material createMaterial(class_1921 renderLayer) {
            class_12247 state = renderLayer.field_64013;
            Map textures = state.field_63987;
            class_12247.class_12338 texture = (class_12247.class_12338)textures.get("Sampler0");
            if (texture != null) {
                String cutout;
                Transparency transparency;
                RenderPipeline pipeline;
                Optional blendFunction;
                SimpleMaterial.Builder builder = SimpleMaterial.builder().texture(texture.comp_5228()).mipmap(false);
                if (!state.field_63991) {
                    builder.useLight(false);
                }
                if (!state.field_63992) {
                    builder.useOverlay(false);
                }
                if ((blendFunction = (pipeline = renderLayer.method_73243()).getBlendFunction()).isPresent() && (transparency = TRANSPARENCY.get(blendFunction.get())) != null) {
                    builder.transparency(transparency);
                }
                if ((cutout = (String)pipeline.getShaderDefines().comp_3103().get("ALPHA_CUTOUT")) != null) {
                    if (cutout.equals("0.1")) {
                        builder.cutout(CutoutShaders.ONE_TENTH);
                    } else if (cutout.equals("0.5")) {
                        builder.cutout(CutoutShaders.HALF);
                    }
                }
                return builder.build();
            }
            return Materials.TRANSLUCENT_ITEM_ENTITY_ITEM;
        }

        public class_4588 method_73477(class_1921 layer) {
            ItemMeshEmitter emitter;
            Integer index = this.objects.chunkLayers.get(layer);
            if (index == null) {
                this.objects.chunkLayers.put(layer, this.objects.chunkLayers.size());
                emitter = new ItemMeshEmitter(layer);
                emitter.prepare(this.resultConsumer, this::emitMesh);
                this.objects.emitters.add(emitter);
            } else {
                emitter = this.objects.emitters.get(index);
                if (emitter.isEnd()) {
                    emitter.prepare(this.resultConsumer, this::emitMesh);
                }
            }
            return emitter;
        }

        public void method_22993() {
            for (ItemMeshEmitter emitter : this.objects.emitters) {
                emitter.end();
            }
        }

        public void method_37104() {
        }

        public void method_22994(class_1921 type) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ResultConsumer {
        public void accept(class_1921 var1, boolean var2, class_9801 var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface MeshResultConsumer {
        public void accept(class_1921 var1, Material var2, Mesh var3, boolean var4);
    }

    @Environment(value=EnvType.CLIENT)
    private static class EmptyBufferSource
    extends class_4597.class_4598 {
        public static final EmptyBufferSource INSTANCE = new EmptyBufferSource();

        public EmptyBufferSource() {
            super(null, null);
        }

        public class_4588 method_73477(class_1921 renderType) {
            return EmptyVertexConsumer.INSTANCE;
        }

        public void method_37104() {
        }

        public void method_22993() {
        }

        public void method_22994(class_1921 type) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class EmptyOutlineBufferSource
    extends class_4618 {
        public static final EmptyOutlineBufferSource INSTANCE = new EmptyOutlineBufferSource();

        private EmptyOutlineBufferSource() {
        }

        public class_4588 method_73477(class_1921 renderType) {
            return EmptyVertexConsumer.INSTANCE;
        }

        public void method_23286(int color) {
        }

        public void method_23285() {
        }
    }
}

